﻿using System;
using System.Collections.Generic;
using System.Text;
using IndianHealthService.BMXNet.WinForm.Configuration;
using System.Windows.Forms;
using IndianHealthService.BMXNet.Services;

namespace IndianHealthService.BMXNet.WinForm.Forms
{
    internal class ConnectionTest
    {

        private IWin32Window _uiOwner = null;

        public IWin32Window UiOwner
        {
            get { return _uiOwner; }
            set { _uiOwner = value; }
        }


        public void Test(RpmsConnectionSpec aSpec)
        {
            WinFramework framework = WinFramework.CreateWithNetworkBroker(false,new NullLog());
            RpmsConnectionSettings settings = new RpmsConnectionSettings();
            settings.AddConnectionSpec(aSpec);
            framework.ConnectionSettings = settings;

            LoginProcess login = framework.CreateLoginProcess();
         

            if (login.HasDefaultConnectionWithUseWindowsAuth && login.AttemptWindowsAuthLogin())
            {
                if (login.AttemptWindowsAuthLogin())
                {
                    MessageBox.Show("Windows Authication was succesful", "Connection Test");
                    framework.Close();
                    return;
                }
                else
                {
                    MessageBox.Show("Windows Authication was failed", "Connection Test");
                    return;
                }
            }

            if (!login.WasLoginAttempted || !login.WasSuccessful)
            {
                if (login.AttemptUserInputLogin("Test Login", 3, false,this.UiOwner))
                {
                    MessageBox.Show("RPMS login  was successful", "Connection Test");
                    framework.Close();
                    return;
                }
                else
                {
                    MessageBox.Show("RPMS login faied", "Connection Test");
                    return;
                }
            }
        }
    }
}